; Flags for MUSE_setFlags.

.enum MUSE_Flags
    ; If set, music updates are paused.
    PAUSE_MUSIC             = %10000000
    ; If set, sound effect updates are paused.
    PAUSE_SFX               = %01000000
    ; If set, pauses both music and sound effects.
    PAUSE                   = PAUSE_MUSIC|PAUSE_SFX
    ; If set, global volume (MUSE_setVolume) doesn't apply to sound effects.
    GLOBAL_VOL_BEFORE_SFX   = %00100000
    ; If set, every 6th frame is skipped (for NTSC).
    SPEED_COMPENSATION      = %00010000
    ; If set, notes are tuned down 1 semitone, 28 cents (for NTSC/Dendy).
    NOTE_FREQ_COMPENSATION  = %00001000
    ; If set, speed and note frequencies are compensated for NTSC.
    NTSC_MODE               = SPEED_COMPENSATION|NOTE_FREQ_COMPENSATION
    ; If set, no speed/frequency compensation is done (the default).
    PAL_MODE                = 0
    ; If set, note frequencies are compensated for Dendy.
    DENDY_MODE              = NOTE_FREQ_COMPENSATION
.endenum
