.include "read_joy.h"

.zeropage

tmp1:       .res 1
tmp2:       .res 1
tmp3:       .res 1

.code

; Reads controller into A and tmp1.
; Unreliable if DMC is playing.
; Preserved: X, Y
; Time: 153 clocks
.align 32
read_joy_fast:
    ; Strobe controller
    lda #1          ; 2
    sta $4016       ; 4
    lda #0          ; 2
    sta $4016       ; 4
    
    ; Read 8 bits
    lda #$80        ; 2
    sta tmp1       ; 3
:       lda $4016       ; *4
    
    ; Merge bits 0 and 1 into carry. Normal
    ; controllers use bit 0, and Famicom
    ; external controllers use bit 1.
    and #$03        ; *2
    cmp #$01        ; *2
    
    ror tmp1       ; *5
    bcc :-          ; *3
            ; -1
    lda tmp1       ; 3
    rts             ; 6


; Reads controller into A.
; Reliable even if DMC is playing.
; Preserved: X, Y
; Time: ~660 clocks
read_joy:
    jsr read_joy_fast
    sta tmp3
    jsr read_joy_fast
    pha
    jsr read_joy_fast
    sta tmp2
    jsr read_joy_fast
    
    ; All combinations of one controller
    ; change and one DMC DMA corruption
    ; leave at least two matching readings,
    ; and never just the first and last
    ; matching. No more than one DMC DMA
    ; corruption can occur.
    
            ; X--X can't occur
    pla
    cmp tmp3
    beq :+          ; XX--
    cmp tmp1
    beq :+          ; -X-X
    
    lda tmp2      ; X-X-
            ; -XX-
            ; --XX
:       cmp #0
    rts
