; Serial input at 57600 8N1 on $4017.D4/D2/D1/D0, with 8-bit CRC
; Define SERIAL_PAL to 1 for PAL NES.
; Define SERIAL_NTSC_PAL to enable set_crc_read_serial_pal.
; Uses in_crc8, temp, in zero-page
; Two stop bits gives 31/29 (NTSC/PAL) extra cycles between calls.

.ifndef SERIAL_MASK
	SERIAL_MASK = %10111
.endif

.ifdef SERIAL_NTSC_PAL
	; Switches to PAL rate. Requires that code be in RAM.
	.macro set_crc_read_serial_pal Zeropage
		lsr Zeropage crc_read_delay_
		asl Zeropage crc_read_period_
	.endmacro
.else
	.ifndef SERIAL_PAL
		SERIAL_NTSC_PAL = 1
	.endif
.endif

.ifndef serial_temp
	serial_temp = <temp
.endif

; Waits for and receives byte.
; Out: A = byte received
;      ORA #0
; Preserved: X, Y
; Cycles between calls: 13 to 30/27 (NTSC/PAL)
.macro crc_read_serial_inline
		.local @Loop
		sta <serial_temp
		lda #SERIAL_MASK
@Loop:  bit $4017
		beq @Loop
		
		jsr crc_read_serial_
		
		and $4017
		cmp #1
		lda <serial_temp
		ror a
		eor #$FF
.endmacro

; Defines routine's code
.macro def_crc_read_serial
		.local Temp
		Temp = serial_temp
		
crc_read_serial_:               ; 8
		bit <Temp               ; 3
crc_read_serial_jmp_:           ; allows extra JMP between JSR

		lda <Temp               ; 13
crc_read_dummy:
		eor <in_crc8
		asl a
		adc #$99
		sta <in_crc8
		
		; delay 7 for NTSC, 3 for PAL
	.ifdef SERIAL_NTSC_PAL
crc_read_delay_:
		pha
		pla
	.else
		bit <$68
	.endif

		lda #$40                ; 2
		
:       sta A:Temp              ; 10
		lda #SERIAL_MASK
		and $4017
		
		; delay 4 for NTSC, 2 for PAL
	.ifdef SERIAL_NTSC_PAL
crc_read_period_:
		clc
		clc
	.else
		.byte $30       ; BMI (not taken)
		clc
	.endif
		
		cmp #1                  ; 17
		ror <Temp
		nop
		lda <Temp
		bcs :+
		jmp :-
		
:       lda #SERIAL_MASK
		rts
.endmacro
