; Two stop bits gives 15/14 (NTSC/PAL) extra cycles between calls.

.ifndef serial_temp
	serial_temp = <temp
.endif

.ifndef serial_saved_x
	serial_saved_x = <temp2
.endif

.ifndef SERIAL_CMP
	SERIAL_CMP = $40
.endif

crc_read_115200_x = SERIAL_CMP

.ifndef SERIAL_FIXED_SPEED
	SERIAL_FIXED_SPEED = 1
.endif

.macro init_crc_read_115200_inline
	lda #crc_read_115200_x
	sta serial_saved_x
.endmacro

; In: A = byte to be checksummed
; Out: A = byte received
;      ORA #0
; Preserved: X, Y
; Cycles between calls: 6 to 16/14 (NTSC/PAL)
.macro crc_read_serial_inline
	stx <serial_saved_x
	ldx #crc_read_115200_x
	crc_read_serial_fastest
.endmacro

; In: A = byte to be checksummed
; Out: A = byte received
;      ORA #0
; Preserved: Y
; Cycles between calls: 11 to 21/19 (NTSC/PAL)
.macro crc_read_serial_fastest
	.local @loop
@loop:  cpx $4017
	bcs @loop
	jsr crc_read_serial_
	eor $4017
.endmacro

.macro def_crc_read_serial
crc_read_serial_:       ; 8
	bit <0          ; 8
crc_read_serial_jmp_:
	nop
	SELECT SERIAL_PAL, ora #0, bit <0
	
	cpx $4017       ; 15
	rol <temp
	eor <in_crc8
	SELECT SERIAL_PAL, ora #0, bit <0
	
	cpx $4017       ; 16
	rol <temp
	asl a
	adc #$99
	SELECT SERIAL_PAL, ora #0, bit <0
	
	cpx $4017       ; 15
	rol <temp
	sta <in_crc8
	SELECT SERIAL_PAL, ora #0, bit <0
	
	cpx $4017       ; 16
	rol <temp
	nop
	nop
	SELECT SERIAL_PAL, ora #0, bit <0
	
	cpx $4017       ; 15
	lda A:temp
	rol a
	and #$1F
	SELECT SERIAL_PAL, ora #0, bit <0
	
	cpx $4017       ; 16
	eor #$C0 ^ (SERIAL_CMP>>2) ^ (SERIAL_CMP>>3)
	rol a
	rol a
	ldx <serial_saved_x
	SELECT SERIAL_PAL, ora #0, bit <0
	
	eor $4017       ; 15
	rol a
	SELECT SERIAL_PAL, ora #0, bit <0
	rts
.endmacro
