; Serial output at 57600 8N1 on $4016.D1/D0, with 8-bit CRC
; Rest of $4016 always cleared.
; Define SERIAL_PAL to 1 for PAL NES.
; Define SERIAL_NTSC_PAL to enable set_crc_write_serial_pal.
; Uses out_crc8, temp, in zero-page

.ifndef SERIAL_OUT_MASK
	SERIAL_OUT_MASK = %11
.endif

.ifdef SERIAL_NTSC_PAL
	; Switches to PAL rate. Requires that code be in RAM.
	.macro set_crc_write_serial_pal Zeropage
		asl Zeropage crc_write_period_
	.endmacro
.else
	.ifndef SERIAL_PAL
		SERIAL_NTSC_PAL = 1
	.endif
.endif

; Defines routine's code
.macro def_crc_write_serial
		sta <temp
		eor <out_crc8   ; begin updating CRC
		asl a
		sta <out_crc8
		lda #0
		sta $4016       ; start bit
		lda <out_crc8   ; finish updating CRC and delay
		adc #$99
		sta <out_crc8
		sec             ; stop bit
:       ror <temp       ; next bit
		lda #$FF
		adc #0
		eor #$FF
		and #SERIAL_OUT_MASK

	.ifdef SERIAL_NTSC_PAL
crc_write_period_:
		clc
		clc
	.else
		.byte $30       ; BMI (not taken)
		clc
	.endif
	
		sta $4016       ; bits 0-7, stop bit
		clc
		lda <temp
		beq :+
		jmp :-
:
.endmacro
