.ifndef SERIAL_OUT_MASK
	SERIAL_OUT_MASK = %11
.endif

.ifndef serial_temp
	serial_temp = <temp
.endif

.ifndef serial_saved_x
	serial_saved_x = <temp2
.endif

.ifndef SERIAL_FIXED_SPEED
	SERIAL_FIXED_SPEED = 1
.endif
; Writes byte A to serial
; Preserved: X, Y
.macro def_crc_write_serial
	stx <serial_saved_x
	sty <serial_temp
	
	tay
	eor <out_crc8           ; update CRC
	asl a
	adc #$99
	sta <out_crc8
	tya
	
	ldx #%01 & SERIAL_OUT_MASK
	stx $4016               ; start
	
	asl a
	ldx #8 / 2
	bne :+
	SELECT SERIAL_PAL, ora #0, {}
@loop:  tya
	ror a
:       tay
	and #SERIAL_OUT_MASK
	sta $4016               ; bit 0 2 4 6
	
	tya
	ror a
	tay
	and #SERIAL_OUT_MASK
	dex
	SELECT SERIAL_PAL, {}, nop
	sta $4016               ; bit 1 3 5 7
	bne @loop
	
	tya
	lsr a
	and #%01 & SERIAL_OUT_MASK
	ora #%10 & SERIAL_OUT_MASK
	
	nop
	sta $4016               ; stop
	
	ldy <serial_temp
	ldx <serial_saved_x
	lsr a
	lda #SERIAL_OUT_MASK
	SELECT SERIAL_PAL, {}, nop
	sta $4016               ; stop
.endmacro
