.include "macros.inc"

; The loader never writes to 0-$2F

; The four 16-bit routine arguments
args            = <$30
arg0            = args+0
arg1            = args+2
arg2            = args+4
arg3            = args+6

; $38-$1EF are reserved for the loader at all times

nrpc_vars       = <$40
nrpc_temp       = nrpc_vars+0
in_crc8         = nrpc_vars+3
out_crc8        = nrpc_vars+5
pal_nes         = nrpc_vars+6   ; 0=NTSC >0=PAL
services        = nrpc_vars+7

; Error code responses
err_checksum    = '1'
err_garbage     = '2'
err_assertion   = '3'

.ifdef SERIAL_PAL
	routine_flag_7 = 1
.else
	routine_flag_6 = 1
.endif

.ifdef SERIAL_115200
	routine_flag_5 = 1
.else
	routine_flag_4 = 1
.endif

serial_temp     = nrpc_temp
serial_saved_x  = nrpc_temp+1
