; Move BSS and code to $200
.segment "BSS"
	.res $200

; Limit code to $800
.segment "CODELIMIT"
	.res $10000 - $800

.segment "CODE"

.include "nrpc.inc"
.include "routine_header.s"
.ifdef SERIAL_115200
	.include "crc_read_serial_115200.inc"
.else
	.include "crc_read_serial.inc"
.endif

routine_exec = main

; Returns to loader to receive next routine block
exit_routine        = services+3*0

; Reports fatal error and stops accepting commands
; In: X = code
fatal_error         = services+3*1

; Sends acknowledgement to host
; Preserved: X, Y
send_ack            = services+3*2

; Updates CRC for sent data and sends byte to host
; In: A = byte to CRC and send
; Preserved: X, Y
crc_write_host      = services+3*3

; Updates CRC, then waits for and receives byte from host
; In: A = byte to be checksummed
; Out: A = byte received
;      ORA #0
; Preserved: X, Y
; Cycles between calls: 1 to 18/15 (NTSC/PAL)
crc_read_host       = services+3*6

; Same as crc_read_host, but gives more time
; Out: A = byte received
;      ORA #0
; Preserved: X, Y
; Cycles between calls: 13 to 30/27 (NTSC/PAL)
;crc_read_host_inline (macro)
crc_read_serial_    = services+3*5 ; used internally

; Begins receiving block of data from host
; Out: A = first byte to pass to next crc_read_host call
; Preserved: X, Y
;begin_block_read

; Ends receiving block and verifies checksum
; In: A = last byte received
; Preserved: X, Y
;end_block_read

; Begins sending block of data to host
; Preserved: X, Y
;begin_block_write

; Ends sending block of data to host
; Preserved: X, Y
;end_block_read

.define crc_read_host_inline crc_read_serial_inline

sync_read_host      = services+3*4
