block_byte = 'B'

; Include at END of source file, so that it can use
; .ifref to only define routines called, reducing
; code size. Too bad ca65 can't automatically strip
; unused routines.

.ifref begin_block_read
begin_block_read:
	; Sync
	jsr sync_read_host
	
	; Ensure that we didn't go past it
	cmp #block_byte
	beq :+
	
	ldy #err_garbage
	jmp fatal_error
	
	; Read CRC
:       sta in_crc8
	jmp crc_read_host
.endif

.ifref end_block_read
end_block_read:
	eor in_crc8
	bne @bad_crc
	jmp send_ack

@bad_crc:
	ldy #err_checksum
	jmp fatal_error
.endif

; Begins writing block
; Preserved: X, Y
.ifref begin_block_write
begin_block_write:
.ifdef NRPC_ENABLE_ACK
	lda #block_byte
	jsr crc_write_host
	lda #0
	sta out_crc8
.endif
	rts
.endif

; Ends writing block and appends checksum
; Preserved: X, Y
.ifref end_block_write
end_block_write:
.ifndef NRPC_ENABLE_ACK
	rts
.else
	lda out_crc8
	jmp crc_write_host
.endif
.endif
