; nes_asm "{active}" {nes_temp} -C `activedir`routine.cfg -DNRPC_ENABLE_ACK
; truncate {nes_temp} 0x1E
; hexedit {nes_temp}
; exit

; nes_asm "{active}" {nes_temp} -C `activedir`routine.cfg
; truncate {nes_temp} 0x1E
; hexedit {nes_temp}
; exit

.define ROUTINE_NAME "nrpc_boot"

SERIAL_NTSC_PAL = 1

.include "nrpc.inc"

.ifdef SERIAL_115200
	.include "crc_read_serial_115200.inc"
	.include "crc_write_serial_115200.inc"
.else
	.include "crc_read_serial.inc"
	.include "crc_write_serial.inc"
.endif

.include "routine_header.s"

header          = args
header_size     = $10

temp            = nrpc_temp
temp2           = nrpc_temp+1
;unused         = nrpc_vars+2
garbage_found   = nrpc_vars+4

.org 0  
	.res 4,$EA ; space for boot header
	.res 3,$EA ; compatibility with old loader (TODO: eliminate)
	
;**** Receive rest of loader

; Once this initialization code has completed, it isn't
; needed anymore and the space becomes available for
; user zero-page variables.
	
.ifdef SERIAL_FIXED_SPEED
	ldy #$140/2
	tax
	SELECT SERIAL_PAL, beq @disable, bne @disable
.else
	tax
	beq @ntsc
	set_crc_read_serial_pal <
	set_crc_write_serial_pal <
	lda #'P' ^ 'N'
@ntsc:  sta pal_nes
.endif
	; Prepare for serial output
	lda #SERIAL_OUT_MASK
	sta $4016
	
	; Must init stack since JSRs could overwrite
	; what we're loading
	ldx #<loader_end
	txs
	
.ifdef SERIAL_FIXED_SPEED
	; Skip
:       jsr crc_read_host
	jsr crc_read_host
	dey
	bne :-
.endif

	; Sync
:       jsr crc_read_host
	cmp #$5A
	bne :-
	sta in_crc8
	
	; Receive rest of code and CRC
:       jsr crc_read_host
	tsx
	pha
	bne :-
	
	; Verify CRC
	eor in_crc8
	bne @disable
	jsr send_ack
	jmp @exit
@disable:
	; Loader is corrupt; disable permanently since
	; execution would result in unpredictable behavior
	ldx #$FE
	stx <disable_loader
	bne @fatal
	
;**** Variables
.align nrpc_vars
	.byte 0,0       ; temp, temp2
	.byte 0         ; unused
	.byte 0         ; crc
	.byte 0         ; garbage_found
	.byte 0         ; out_crc
	SELECT SERIAL_PAL, .byte 'P'^'N', .byte 0 ; pal_nes
	
;**** Service vectors
@exit:  jmp exit_routine
@fatal: jmp fatal_error
	jmp send_ack
	jmp crc_write_host
	jmp sync_read_host
	jmp crc_read_serial_jmp_

crc_read_host:
	crc_read_serial_inline
	rts

	def_crc_read_serial

; Sends acknowledgement to host
; Preserved: Y
send_ack:
.ifndef NRPC_ENABLE_ACK
	rts
	.res 3
.else
	lda #'N'
	eor pal_nes
	; FALL THROUGH
.endif

crc_write_host:
	def_crc_write_serial
	rts

fatal_error:
	lda #$45 ; 'E'
	jsr crc_write_host
	txa
	jsr crc_write_host
	
loader_corrupt:
	
.ifdef NRPC_ENABLE_ACK
	; Keep code size the same
	.res 16,$EA
	lda #$21
.else
	; Make ugly sound that clearly indicates error
	lda #$3A
	sta $4015
	ldx #-16
:       sta $4000 - <-16,x
	inx
	bne :-
	
	; Colored screen as well
	lda #$21
	sta $2001
.endif
	
disable_loader = * + 1
	bne :+

; Wait for header
; Goes back to waiting for another command
routine_exec:
exit_routine:
	lda #$FF
:       ldx #$FF
	txs
	
	; Wait for first byte of header
@garbage:
	sta garbage_found
	jsr sync_read_host
	cmp #$D4
	bne @garbage
	
	ldx #-header_size
	
	; Verify signature
	ldy #3 - 1
:       jsr crc_read_host
	eor reversed_signature,y
	bne @garbage
	dey
	bpl :-

	sta in_crc8     ; CRC = 0
	
	; Receive header
:       tay
	jsr crc_read_host
	sta <(header - <-header_size),x
	inx
	bne :-
	
	; Verify header CRC
	cmp in_crc8
	bne @crc_error

	; Receive data
	tax
:       jsr crc_read_host
	sta (header+$A),y
	iny
	bne :-
	inx
	beq :+
	jsr crc_read_host
	inc header+$B   ; avoids taking too long
	sta (header+$A),y
	iny
	bne :-
:
	; Verify data CRC
	eor in_crc8
	cmp header+$C
	bne @crc_error
	
	; Error if garbage found and key wasn't present
	ldx #err_garbage
	ldy garbage_found
	beq :+
	iny
	bne @fatal_error
	jsr send_ack
:
	; Execute routine
	jsr :+
	jmp exit_routine
:
	jmp (header+8)

@crc_error:
	ldx #err_checksum
@fatal_error:
	jmp fatal_error
	
sync_read_host:
:       crc_read_serial_inline
	cmp #$FF
	beq :-
	rts
	
; At end so stack overflow will overwrite and cause it to
; stop responding
reversed_signature:
	.byte $2B,$CC,$5B

loader_end:
