.define ROUTINE_NAME "write_fpga_config"

.include "routine.inc"


gamegenie      = $4204
gg_tmpdata     = $700
fpga_data      = $5C00
mapper_size    = 42166

main:
    ldy #<-mapper_size
    
    ldx #29

    jsr begin_block_read

    ; first copy the game genie data, 30 bytes total, to memory.. we'll copy them to $700    
    ; note that gg_enable is $FF for 8 char codes, 0 otherwise
    ; order is: newbyte, enable, compare, addrlow, addrhigh
    ; after 5 gg codes like this, 5 bytes for the WRAM_FLAG:
    ;   WRAM_FLAG, 2x zero, $8, $42
    
    ; read backwards.. doesn't matter because we'll read it backwards when writing as well
:
    jsr crc_read_host
    sta gg_tmpdata,x
    dex
    bpl :-

	ldx #>-mapper_size

:
	jsr crc_read_host
	sta fpga_data
	iny
	bne :-
	inx
	bne :-
	
	jsr end_block_read
    
    ldx #29
:
    lda gg_tmpdata,x
    sta gamegenie
    dex
    bpl :-
    ; the above code runs for 30 iterations, so about 13*30 = 390 cycles
    	
	rts

.include "routine_end.s"
